#!/usr/local/bin/perl

# Use this script file to install msql Keeper.  
# It will create the directories and copy the source files to the 
# appropriate locations.  
#
# BEFORE YOU RUN THIS SCRIPT:
# 	Create a directory called /source on your web server root directory
# 	Unzip mk.zip 
# 	Copy all files to /source.  
# 	Execute this script.


use CGI;
$q 	 = new CGI;
print $q->header;
print $q->start_html('Install mSQL Keeper','','','','','','BGCOLOR="#FFFFFF"');

$root_path = $ENV{'DOCUMENT_ROOT'};

if (not opendir (SOURCE_DIR, "$root_path/source")) {
	print "Unable to open directory $root_path/source<br>\n";
	print "Reason $!";
	exit;	
}

mkdir ("$root_path/msql_keeper", 0755) or print "Cant: $! <br>\n"; 
mkdir ("$root_path/msql_keeper/cgi", 0755) or print "Cant: $! <br>\n"; 
mkdir ("$root_path/msql_keeper/lib", 0755) or print "Cant: $! <br>\n"; 
mkdir ("$root_path/msql_keeper/indata", 0755) or print "Cant: $! <br>\n"; 
mkdir ("$root_path/msql_keeper/dumpdata", 0755) or print "Cant: $! <br>\n"; 
mkdir ("$root_path/msql_keeper/img", 0755) or print "Cant: $! <br>\n"; 
mkdir ("$root_path/msql_keeper/config", 0755) or print "Cant: $! <br>\n"; 

while ($file = readdir(SOURCE_DIR)) {
	
	my $ext  = &filext($file);
	
	if ($ext eq 'gif') {
		rename "$root_path/source/$file", "$root_path/msql_keeper/img/$file" or print "Cant rename $root_path/source/$file to $root_path/msql_keeper/img/$file Reason:$! <br>\n";
		chmod 0500, "$root_path/msql_keeper/img/$file" or print "Cant change permissions to $root_path/msql_keeper/img/$file Reason:$! <br>\n";

	} elsif ($ext eq 'cgi') {
		rename "$root_path/source/$file", "$root_path/msql_keeper/cgi/$file" or print "Cant rename $root_path/source/$file to $root_path/msql_keeper/cgi/$file Reason:$! <br>\n";
		chmod 0755, "$root_path/msql_keeper/cgi/$file" or print "Cant change permissions to $root_path/msql_keeper/cgi/$file Reason:$! <br>\n";

	} elsif ($ext eq 'shtml') {
		rename "$root_path/source/$file", "$root_path/msql_keeper/$file" or print "Cant rename $root_path/source/$file: $! <br>\n";
		chmod 0500, "$root_path/msql_keeper/$file" or print "Cant change permissions to $root_path/msql_keeper/$file Reason:$! <br>\n";

	} elsif ($ext eq 'dat') {
		rename "$root_path/source/$file", "$root_path/msql_keeper/config/$file" or print "Cant rename $root_path/source/$file: $!<br>\n";
		chmod 0755, "$root_path/msql_keeper/config/$file" or print "Cant change permissions to $root_path/msql_keeper/config/$file Reason:$! <br>\n";

	} elsif ($ext eq 'pm') {
		rename "$root_path/source/$file", "$root_path/msql_keeper/lib/$file" or print "Cant rename $root_path/source/$file: $!<br>\n";
		chmod 0755, "$root_path/msql_keeper/lib/$file" or print "Cant change permissions to $root_path/msql_keeper/lib/$file Reason:$! <br>\n";

	} elsif ($ext eq 'dbf') {
		rename "$root_path/source/$file", "$root_path/msql_keeper/indata/$file" or print "Cant: $! <br>\n";
		
	} elsif ("\L$file\E" eq 'text.txt') {
		rename "$root_path/source/$file", "$root_path/msql_keeper/indata/$file" or print "Cant: $! <br>\n";
	}
}

print "<h1>mSQL Keeper Installation</h1>\n<br>mSQL Keeper Installation completed!\n <a href = \"/msql_keeper/\">Click here</a> to try it.";
closedir(SOURCE_DIR);
print $q->end_html;
exit;

sub filext {
	my ($file_path) = @_;
	my $inx = rindex($file_path, ".");
	return substr($file_path, $inx + 1);
}
